<?php


function kenic_getConfigArray() {
	$configarray = array(
		"Username" => array( "Type" => "text", "Size" => "20", "Description" => "Enter your kenic client code here", ),
		"Password" => array( "Type" => "password", "Size" => "20", "Description" => "Enter your kenic epp password here", ),
	);
	return $configarray;
}

function kenic_GetNameservers($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	# Put your code to get the nameservers here and return the values below
	include "epp_commands.php";
	$url = $server . urlencode($get_domain_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	if($jsonObject->epp->response->result->code != "1000"){
		$error = $jsonObject->epp->response->result->msg;
	}

	$values["ns1"] = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[0];
	$values["ns2"] = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[1];
	$values["ns3"] = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[2];
	$values["ns4"] = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[3];
	$values["ns5"] = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[4];
	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_SaveNameservers($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	$nameserver1 = $params["ns1"];
	$nameserver2 = $params["ns2"];
	$nameserver3 = $params["ns3"];
	$nameserver4 = $params["ns4"];
	$nameserver5 = $params["ns5"];
	# Put your code to save the nameservers here
	include "epp_commands.php";
	$url = $server . urlencode($get_domain_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	$ns1 = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[0];
	$ns2 = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[1];
	$ns3 = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[2];
	$ns4 = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[3];
	$ns5 = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:ns"}->{"domain:hostObj"}[4];

	include "epp_commands.php";
	$update_domain_ns = "";
	if(isset($ns3) && isset($ns4) && isset($ns5)){
		$update_domain_ns = $update_domain_ns_1 .''. $ns_rem_3 .''. $ns_rem_4 .''. $ns_rem_5 .''. $update_domain_ns_2;
	} else if(isset($ns3) && isset($ns4) && empty($ns5)){
		$update_domain_ns = $update_domain_ns_1 .''. $ns_rem_3 .''. $ns_rem_4 .''. $update_domain_ns_2;
	}else if(isset($ns3) && empty($ns4) && empty($ns5)){
		$update_domain_ns = $update_domain_ns_1 .''. $ns_rem_3 .''. $update_domain_ns_2;
	}else {
		$update_domain_ns = $update_domain_ns_1 .''. $update_domain_ns_2;
	}

	$update_domain_ns_fin = "";
	if(!empty($nameserver3) && !empty($nameserver4) && !empty($nameserver5)){
		$update_domain_ns_fin = $update_domain_ns .''. $ns_add_3 .''. $ns_add_4 .''. $ns_add_5 .''. $update_domain_ns_3;
	} else if(!empty($nameserver3) && !empty($nameserver4) && empty($nameserver5)){
		$update_domain_ns_fin = $update_domain_ns .''. $ns_add_3 .''. $ns_add_4 .''. $update_domain_ns_3;
	}else if(!empty($nameserver3) && empty($nameserver4) && empty($nameserver5)){
		$update_domain_ns_fin = $update_domain_ns .''. $ns_add_3 .''. $update_domain_ns_3;
	}else {
		$update_domain_ns_fin = $update_domain_ns .''. $update_domain_ns_3;
	}
	

	#Check Nameservers
	if(!empty($nameserver1)){
		$nameserver = $params["ns1"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	if(!empty($nameserver2)){
		$nameserver = $params["ns2"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	if(!empty($nameserver3)){
		$nameserver = $params["ns3"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	if(!empty($nameserver4)){
		$nameserver = $params["ns4"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	if(!empty($nameserver5)){
		$nameserver = $params["ns5"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	$url = $server . urlencode($update_domain_ns_fin) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	if($jsonObject->epp->response->result->code != "1000"){
		$error = $jsonObject->epp->response->result->msg;
	}

	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_GetEPPCode($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	# Put your code to request the EPP code here - if the API returns it, pass back as below - otherwise return no value and it will assume code is emailed
	include "epp_commands.php";
	$url = $server . urlencode($get_domain_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	$values["eppcode"] = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:authInfo"}->{"domain:pw"};
	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_RegisterNameserver($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	$nameserver = $params["nameserver"];
	$ipaddress = $params["ipaddress"];
	# Put your code to register the nameserver here
	include "epp_commands.php";
	$url = $server . urlencode($register_ns_servers) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);
	if($jsonObject->epp->response->result->code != "1000"){
		$error = $jsonObject->epp->response->result->msg;
	}
	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_ModifyNameserver($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	$nameserver = $params["nameserver"];
	$currentipaddress = $params["currentipaddress"];
	$newipaddress = $params["newipaddress"];
	# Put your code to update the nameserver here
	include "epp_commands.php";
	$url = $server . urlencode($update_ns_servers) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);
	if($jsonObject->epp->response->result->code != "1000"){
		$error = $jsonObject->epp->response->result->msg;
	}
	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_DeleteNameserver($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	$nameserver = $params["nameserver"];
	# Put your code to delete the nameserver here
	include "epp_commands.php";
	$url = $server . urlencode($delele_ns_servers) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);
	if($jsonObject->epp->response->result->code != "1000"){
		$error = $jsonObject->epp->response->result->msg;
	}
	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_RenewDomain($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	$regperiod = $params["regperiod"];
	# Put your code to renew domain here
	include "epp_commands.php";
	$url = $server . urlencode($get_domain_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);
	$exp_date = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:exDate"};

	include "epp_commands.php";
	$url = $server . urlencode($renew_domain) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);
	$exp_date = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:exDate"};

	if($jsonObject->epp->response->result->code != "1000"){
		$error = $jsonObject->epp->response->result->msg;
	}
	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_RegisterDomain($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	$regperiod = $params["regperiod"];
	$nameserver1 = $params["ns1"];
	$nameserver2 = $params["ns2"];
	$nameserver3 = $params["ns3"];
	$nameserver4 = $params["ns4"];
	$nameserver5 = $params["ns5"];
	# Registrant Details
	$RegistrantFirstName = $params["firstname"];
	$RegistrantLastName = $params["lastname"];
	$RegistrantAddress1 = $params["address1"];
	$RegistrantAddress2 = $params["address2"];
	$RegistrantCity = $params["city"];
	$RegistrantStateProvince = $params["state"];
	$RegistrantPostalCode = $params["postcode"];
	$RegistrantCountry = $params["country"];
	$RegistrantEmailAddress = $params["email"];
	$RegistrantPhone = $params["phonenumber"];

	# Put your code to register domain here
	$unique_key = substr(md5(rand(0, 1000000)), 0, 10);
	$clId = $username ."". $unique_key;

	#Check Nameservers
	if(!empty($nameserver1)){
		$nameserver = $params["ns1"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	if(!empty($nameserver2)){
		$nameserver = $params["ns2"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	if(!empty($nameserver3)){
		$nameserver = $params["ns3"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	if(!empty($nameserver4)){
		$nameserver = $params["ns4"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}
	
	if(!empty($nameserver5)){
		$nameserver = $params["ns5"];
		include "epp_commands.php";
		$url = $server . urlencode($host_info) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
		if($jsonObject->epp->response->result->code != "1000"){
			include "epp_commands.php";
			$url = $server . urlencode($create_host) ."&username=". $username ."&password=". $password ."&resptype=json";
			$jsonText = @file_get_contents($url);
			$jsonObject = json_decode($jsonText);
		}
	}

	#Create registrant contact
	include "epp_commands.php";
	$url = $server . urlencode($create_contact) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);

	#Create admin contact
	include "epp_commands.php";
	$url = $server . urlencode($create_admin) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);

	#Create tech contact
	include "epp_commands.php";
	$url = $server . urlencode($create_tech) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);

	#register domain
	$domain_pass = substr(md5(rand(0, 1000000)), 0, 13);
	include "epp_commands.php";
	$url = $server . urlencode($register_domain) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	if($jsonObject->epp->response->result->code != "1000"){
		$error = $jsonObject->epp->response->result->msg;
		#Delete admin contact
		include "epp_commands.php";
		$url = $server . urlencode($delete_contact) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
	}

	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_GetContactDetails($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	# Put your code to get WHOIS data here
	
	include "epp_commands.php";
	$url = $server . urlencode($get_domain_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	$clId = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:registrant"};
	$billing_id = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:contact"}[0]->content;
	$admin_id = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:contact"}[1]->content;
	$tech_id = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:contact"}[2]->content;

	include "epp_commands.php";
	$url = $server . urlencode($get_contact_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	$values["Registrant"]["Name"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:name"};						
	$values["Registrant"]["City"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:city"};
	$values["Registrant"]["Postal Address"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:pc"};
	$values["Registrant"]["Country"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:cc"};
	$values["Registrant"]["Telephone Number"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:voice"}->{"content"};
	$values["Registrant"]["Email Address"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:email"};
	$values["Registrant"]["Organization"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:org"};


	$clId = $admin_id;
	include "epp_commands.php";
	$url = $server . urlencode($get_contact_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	$values["Admin"]["Name"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:name"};						
	$values["Admin"]["City"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:city"};
	$values["Admin"]["Postal Address"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:pc"};
	$values["Admin"]["Country"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:cc"};
	$values["Admin"]["Telephone Number"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:voice"}->{"content"};
	$values["Admin"]["Email Address"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:email"};
	$values["Admin"]["Organization"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:org"};


	$clId = $tech_id;
	include "epp_commands.php";
	$url = $server . urlencode($get_contact_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	$values["Tech"]["Name"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:name"};						
	$values["Tech"]["City"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:city"};
	$values["Tech"]["Postal Address"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:pc"};
	$values["Tech"]["Country"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:addr"}->{"contact:cc"};
	$values["Tech"]["Telephone Number"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:voice"}->{"content"};
	$values["Tech"]["Email Address"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:email"};
	$values["Tech"]["Organization"] = $jsonObject->epp->response->resData->{"contact:infData"}->{"contact:postalInfo"}->{"contact:org"};

	return $values;
}

function kenic_SaveContactDetails($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	# Data is returned as specified in the GetContactDetails() function
	include "epp_commands.php";
	$url = $server . urlencode($get_domain_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	$clId = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:registrant"};
	$billing_id = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:contact"}[0]->{"content"};
	$admin_id = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:contact"}[1]->{"content"};
	$tech_id = $jsonObject->epp->response->resData->{"domain:infData"}->{"domain:contact"}[2]->{"content"};


#Registrant contacts
	$name = $params["contactdetails"]["Registrant"]["Name"];
	$organization = $params["contactdetails"]["Registrant"]["Organization"];
	$RegistrantCity = $params["contactdetails"]["Registrant"]["City"];
	$RegistrantStateProvince = $params["contactdetails"]["Registrant"]["State/Province"];
	$RegistrantPostalCode = $params["contactdetails"]["Registrant"]["Postal Address"];
	$RegistrantCountry = $params["contactdetails"]["Registrant"]["Country"];
	$RegistrantPhone = $params["contactdetails"]["Registrant"]["Telephone Number"];
	$RegistrantEmailAddress = $params["contactdetails"]["Registrant"]["Email Address"];

	include "epp_commands.php";
	$url = $server . urlencode($update_contact) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);


#Admin contacts
	$name = $params["contactdetails"]["Admin"]["Name"];
	$organization = $params["contactdetails"]["Admin"]["Organization"];
	$RegistrantCity = $params["contactdetails"]["Admin"]["City"];
	$RegistrantStateProvince = $params["contactdetails"]["Admin"]["State/Province"];
	$RegistrantPostalCode = $params["contactdetails"]["Admin"]["Postal Address"];
	$RegistrantCountry = $params["contactdetails"]["Admin"]["Country"];
	$RegistrantPhone = $params["contactdetails"]["Admin"]["Telephone Number"];
	$RegistrantEmailAddress = $params["contactdetails"]["Admin"]["Email Address"];

	$clId = $admin_id;
	include "epp_commands.php";
	$url = $server . urlencode($update_contact) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

#Tech contacts
	$name = $params["contactdetails"]["Tech"]["Name"];
	$organization = $params["contactdetails"]["Tech"]["Organization"];
	$RegistrantCity = $params["contactdetails"]["Tech"]["City"];
	$RegistrantStateProvince = $params["contactdetails"]["Tech"]["State/Province"];
	$RegistrantPostalCode = $params["contactdetails"]["Tech"]["Postal Address"];
	$RegistrantCountry = $params["contactdetails"]["Tech"]["Country"];
	$RegistrantPhone = $params["contactdetails"]["Tech"]["Telephone Number"];
	$RegistrantEmailAddress = $params["contactdetails"]["Tech"]["Email Address"];

	$clId = $tech_id;	
	include "epp_commands.php";
	$url = $server . urlencode($update_contact) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);


	# Put your code to save new WHOIS data here
	# If error, return the error message in the value below
	$values["error"] = $error;
	return $values;
}

function kenic_GetRegistrarLock($params) {
        $server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$testmode = $params["TestMode"];
	$tld = $params["tld"];
	$sld = $params["sld"];
	# Put your code to get the lock status here
	include "epp_commands.php";
	$url = $server . urlencode($get_domain_info) ."&username=". $username ."&password=". $password ."&resptype=json";
	$jsonText = @file_get_contents($url);
	$jsonObject = json_decode($jsonText);

	if($jsonObject->epp->response->resData->{"domain:infData"}->{"domain:status"}->s == 'ok'){
		$lockstatus="unlocked";
	} else {
		$lockstatus="locked";
	}
	return $lockstatus;
}

function kenic_SaveRegistrarLock($params) {
	$server = "http://regsys.kenic.or.ke/registrarTest/general?command=";
	$username = $params["Username"];
	$password = $params["Password"];
	$testmode = $params["TestMode"];
	$tld = $params["tld"];
	$sld = $params["sld"];
        $status = $params["lockenabled"];

	if ($status == 'locked') {
		include "epp_commands.php";
		$url = $server . urlencode($lockdomain) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
	} else {
		include "epp_commands.php";
		$url = $server . urlencode($clientupdateremove) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);

		include "epp_commands.php";
		$url = $server . urlencode($finalunload) ."&username=". $username ."&password=". $password ."&resptype=json";
		$jsonText = @file_get_contents($url);
		$jsonObject = json_decode($jsonText);
	} 

	# Put your code to save the registrar lock here
	# If error, return the error message in the value below

	#$values["error"] = $Enom->Values["Err1"];

	return $values;
}

?>
